<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Swiper_Horizontal extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Swiper Horizontal', 'fl-builder'),
            'description'     => __('Manual horizontal swiper carousel', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'slides.svg',
        ]);
    }


}

// Manual testimonial item form
FLBuilder::register_settings_form('az_testimonial_manual_item_form', [
    'title' => __('Manual Testimonial Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'name' => [
                            'type'  => 'text',
                            'label' => __('Name', 'fl-builder'),
                        ],
                        'description' => [
                            'type'  => 'editor',
                            'label' => __('Description', 'fl-builder'),
                        ],
                        'media_type' => [
                            'type'    => 'select',
                            'label'   => __('Display Media', 'fl-builder'),
                            'default' => 'image',
                            'options' => [
                                'image' => __('Upload Image', 'fl-builder'),
                                'icon'  => __('Select Icon', 'fl-builder'),
                            ],
                            'toggle' => [
                                'image' => ['fields' => ['photo']],
                                'icon'  => ['fields' => ['icon']],
                            ],
                        ],
                        'photo' => [
                            'type'  => 'photo',
                            'label' => __('Image Upload', 'fl-builder'),
                        ],
                        'icon' => [
                            'type'  => 'icon',
                            'label' => __('Icon', 'fl-builder'),
                        ],
                        'link_url' => [
                            'type'  => 'link',
                            'label' => __('Link URL', 'fl-builder'),
                        ],
                    ]
                ]
            ]
        ]
    ]
]);



// Register horizontal swiper module (manual only)
FLBuilder::register_module('AZ_Swiper_Horizontal', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [
                    'manual_testimonials' => [
                        'type'         => 'form',
                        'label'        => __('Testimonials (Manual)', 'fl-builder'),
                        'form'         => 'az_testimonial_manual_item_form',
                        'preview_text' => 'name',
                        'multiple'     => true,
                    ],
                    'nav_icon_left' => [
                        'type'    => 'icon',
                        'label'   => __('Left Arrow Icon', 'fl-builder'),
                        'default' => 'fa fa-chevron-left',
                    ],
                    'nav_icon_right' => [
                        'type'    => 'icon',
                        'label'   => __('Right Arrow Icon', 'fl-builder'),
                        'default' => 'fa fa-chevron-right',
                    ],
                    'nav_color' => [
                        'type'       => 'color',
                        'label'      => __('Arrow & Bullet Color', 'fl-builder'),
                        'default'    => '#333333',
                        'show_reset' => true,
                    ],
                    'nav_hover_color' => [
                        'type'       => 'color',
                        'label'      => __('Arrow & Bullet Hover Color', 'fl-builder'),
                        'default'    => '#1d9fd9',
                        'show_reset' => true,
                    ],
                    'bg_color' => [
                        'type'       => 'color',
                        'label'      => __('Background Color', 'fl-builder'),
                        'default'    => '#ffffff',
                        'show_reset' => true,
                    ],
                ],
            ],

            // NEW: Slides per view controls
            'slides' => [
                'title'  => __('Slides per View', 'fl-builder'),
                'fields' => [
                    'slides_desktop' => [
                        'type'        => 'unit',
                        'label'       => __('Desktop (≥1024px)', 'fl-builder'),
                        'default'     => '5',
                        'description' => __('slides', 'fl-builder'),
                    ],
                    'slides_tablet' => [
                        'type'        => 'unit',
                        'label'       => __('iPad / Tablet (≥768px)', 'fl-builder'),
                        'default'     => '3',
                        'description' => __('slides', 'fl-builder'),
                    ],
                    'slides_mobile' => [
                        'type'        => 'unit',
                        'label'       => __('Mobile (<768px)', 'fl-builder'),
                        'default'     => '2',
                        'description' => __('slides', 'fl-builder'),
                    ],
                ],
            ],
        ],
    ],
]);
