(function($){
  $(document).ready(function(){
    $('.az-social-btn').on('click', function(){
      var type = $(this).data('social');
      var url = encodeURIComponent(window.location.href);
      var text = encodeURIComponent(document.title);
      var shareUrl = '';

      switch(type){
        case 'facebook': shareUrl = 'https://www.facebook.com/sharer/sharer.php?u=' + url; break;
        case 'twitter': shareUrl = 'https://twitter.com/intent/tweet?url=' + url + '&text=' + text; break;
        case 'linkedin': shareUrl = 'https://www.linkedin.com/shareArticle?mini=true&url=' + url; break;
        case 'whatsapp': shareUrl = 'https://wa.me/?text=' + text + '%20' + url; break;
        case 'email': shareUrl = 'mailto:?subject=' + text + '&body=' + url; break;
      }

      if (shareUrl) {
        window.open(shareUrl, '_blank', 'noopener,noreferrer');
      }
    });
  });
})(jQuery);
