<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);

$socials = [
  'facebook' => ['Facebook', $settings->show_facebook === 'yes', $settings->facebook_color ?? '#1877F2'],
  'twitter' => ['Twitter', $settings->show_twitter === 'yes', $settings->twitter_color ?? '#1DA1F2'],
  'linkedin' => ['LinkedIn', $settings->show_linkedin === 'yes', $settings->linkedin_color ?? '#0077B5'],
  'whatsapp' => ['WhatsApp', $settings->show_whatsapp === 'yes', $settings->whatsapp_color ?? '#25D366'],
  'email' => ['Email', $settings->show_email === 'yes', $settings->email_color ?? '#666666'],
];

?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-share-social.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

  <div class="az-share-social">
    <?php foreach ($socials as $key => [$label, $toggle, $color]) : ?>
  <?php if ($toggle) : ?>
    <?php $icon = ($key === 'email') ? 'fas fa-envelope' : 'fab fa-' . $key; ?>
    <button class="az-social-btn" data-social="<?= esc_attr($key) ?>" style="background-color: <?= esc_attr($color) ?>">
      <i class="<?= esc_attr($icon) ?>"></i> <?= esc_html($label) ?>
    </button>
  <?php endif; ?>
<?php endforeach; ?>

  </div>

</section>

<script src="<?php echo esc_url($module->url . 'js/az-share-social.js'); ?>"></script>
