<?php
/**
 * Template partial: Default AZ Post Card
 * Receives `$args` which contains 'settings' and 'post_type'
 */
$settings  = isset($args['settings']) ? $args['settings'] : null;
$post_type = isset($args['post_type']) ? $args['post_type'] : 'post';
$product   = ($post_type === 'product' && function_exists('wc_get_product')) ? wc_get_product(get_the_ID()) : null;
?>

<a href="<?php the_permalink(); ?>">
    <?php if (has_post_thumbnail() && $settings->show_product_thumbnail === 'yes'): ?>
        <?php if ($post_type === 'product'): ?>
            <?php
                $gallery_ids = $product ? $product->get_gallery_image_ids() : [];
                $main_img = get_the_post_thumbnail(get_the_ID(), 'woocommerce_thumbnail', ['class' => 'main-image']);
                $hover_img = '';

                if (!empty($gallery_ids)) {
                    $hover_img_url = wp_get_attachment_image_url($gallery_ids[0], 'woocommerce_thumbnail');
                    $hover_img = '<img src="' . esc_url($hover_img_url) . '" class="hover-image" />';
                }

                echo '<div class="product-thumb-hover">' . $main_img . $hover_img . '</div>';
            ?>
        <?php else: ?>
            <div class="post-thumb">
                <div class="bg-featured" style="background-image: url('<?php echo get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>');"></div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <div class="content">
        <?php if ($settings->display_date === 'yes'): ?>
            <p class="post-date"><?php echo get_the_date('F j, Y'); ?></p>
        <?php endif; ?>

        <h4><?php the_title(); ?></h4>

        <?php if ($settings->show_description === 'yes'): ?>
            <p><?php echo wp_trim_words(get_the_excerpt(), $settings->excerpt_length); ?></p>
        <?php endif; ?>

        <?php if ($post_type === 'product'): ?>
            <?php if ($settings->show_product_price === 'yes' && $product): ?>
                <div class="product-price"><?php echo $product->get_price_html(); ?></div>
            <?php endif; ?>

            <?php if ($settings->show_add_to_cart === 'yes' && $product): ?>
                <a href="?add-to-cart=<?php echo esc_attr($product->get_id()); ?>"
                   class="button add_to_cart_button ajax_add_to_cart"
                   data-product_id="<?php echo esc_attr($product->get_id()); ?>">
                    <?php esc_html_e('Add to cart', 'woocommerce'); ?>
                </a>
            <?php endif; ?>
        <?php endif; ?>
    </div>

    <span class="icon"><i class="fas fa-chevron-right"></i></span>
</a>
