<?php
add_action('wp_ajax_az_load_more_posts', 'az_ajax_load_more_posts');
add_action('wp_ajax_nopriv_az_load_more_posts', 'az_ajax_load_more_posts');

function az_ajax_load_more_posts() {
    $paged = isset($_POST['paged']) ? intval($_POST['paged']) : 1;
    $settings = $_POST['settings'];
    $category_slugs = [];

    if ($settings['enable_filter'] === 'yes' && !empty($settings['categories'])) {
        $category_slugs = array_map('trim', explode(',', $settings['categories']));
    } elseif (!empty($settings['single_category'])) {
        $category_slugs = [trim($settings['single_category'])];
    }

    $tax_query = [];
    $taxonomies = get_object_taxonomies($settings['post_type']);

    if (!empty($category_slugs)) {
        $tax_query[] = [
            'taxonomy' => $taxonomies[0],
            'field'    => 'slug',
            'terms'    => $category_slugs,
        ];
    }

    $args = [
        'post_type'      => $settings['post_type'],
        'posts_per_page' => intval($settings['posts_per_page'] ?? 6),
        'paged'          => $paged,
        'post_status'    => 'publish',
    ];

    if (!empty($tax_query)) {
        $args['tax_query'] = $tax_query;
    }

    $query = new WP_Query($args);
    $html = '';

    if ($query->have_posts()) {
        ob_start();
        while ($query->have_posts()) : $query->the_post();
            $terms = wp_get_post_terms(get_the_ID(), $taxonomies[0], ['fields' => 'slugs']);
            ?>
            <article class="az-post-item" data-cats="<?php echo esc_attr(implode(' ', $terms)); ?>">
                <a href="<?php the_permalink(); ?>">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="az-post-thumb image-bg" style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>');"></div>
                    <?php endif; ?>
                    <p class="az-post-title"><?php the_title(); ?></p>
                </a>
            </article>
            <?php
        endwhile;
        $html = ob_get_clean();
        wp_reset_postdata();
        wp_send_json_success(['html' => $html]);
    }

    wp_send_json_error();
}
