<?php

if (!class_exists('FLBuilderModule')) {
    return;
}

class AZ_Post_Filtering extends FLBuilderModule
{
    public function __construct()
    {
        parent::__construct([
            'name'            => __('AZ Post Filtering', 'fl-builder'),
            'description'     => __('Display and filter posts by category.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'schedule.svg',
        ]);
    }
}

// Register the module and its settings
FLBuilder::register_module('AZ_Post_Filtering', [
    'general' => [
        'title'    => __('Post Display Settings', 'fl-builder'),
        'sections' => [
            'source_settings' => [
                'title'  => __('Post Source', 'fl-builder'),
                'fields' => [
                    'post_type' => [
                        'type'    => 'select',
                        'label'   => __('Post Type', 'fl-builder'),
                        'default' => 'post',
                        'options' => az_get_all_post_types(),
                        'toggle'  => [
                            'refresh' => true, // Reload categories dynamically
                        ],
                    ],
                    'enable_filter' => [
                        'type'    => 'select',
                        'label'   => __('Enable Category Filter?', 'fl-builder'),
                        'default' => 'no',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                        'toggle' => [
                            'yes' => [
                                'fields' => ['categories'],
                            ],
                            'no' => [
                                'fields' => ['single_category'],
                            ],
                        ],
                    ],
                    'categories' => [
                        'type'  => 'text',
                        'label' => __('Enter Category Slugs (comma-separated)', 'fl-builder'),
                        'help'  => __('Example: category1, category2, category3', 'fl-builder'),
                        'show'  => [
                            'enable_filter' => 'yes',
                        ],
                    ],
                    'posts_per_page' => [
                        'type'    => 'unit',
                        'label'   => __('Posts Per Page', 'fl-builder'),
                        'default' => 6,
                        'units'   => ['px'], // visually hidden, but required
                        'preview' => [
                            'type' => 'none',
                        ],
                    ],
                    'load_mode' => [
                        'type'    => 'select',
                        'label'   => __('Load Mode', 'fl-builder'),
                        'default' => 'load_more',
                        'options' => [
                            'load_more'  => __('Load More Button', 'fl-builder'),
                            'pagination' => __('Pagination', 'fl-builder'),
                        ],
                    ],
                    'single_category' => [
                        'type'  => 'text',
                        'label' => __('Category Slug (if filter disabled)', 'fl-builder'),
                        'show'  => [
                            'enable_filter' => 'no',
                        ],
                    ],
                ],
            ],
        ],
    ],
]);

/**
 * Helper: Get taxonomy terms based on the selected post type.
 */
function az_get_dynamic_categories_by_post_type($field)
{
    $post_type = 'post'; // Default to 'post' if no post type is selected
    
    if (!empty($field->settings->post_type)) {
        $post_type = sanitize_key($field->settings->post_type);
    }

    $options = [];
    $taxonomies = get_object_taxonomies($post_type, 'objects');

    foreach ($taxonomies as $taxonomy) {
        if ($taxonomy->public && $taxonomy->hierarchical) {
            $terms = get_terms([
                'taxonomy'   => $taxonomy->name,
                'hide_empty' => false,
            ]);

            foreach ($terms as $term) {
                $options[$term->slug] = $taxonomy->label . ': ' . $term->name;
            }
        }
    }

    return $options;
}

// Load post rendering logic
require_once plugin_dir_path(__FILE__) . 'load-more.php';
