<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-pillar.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">


   <?php
if (!empty($settings->photo_field)) {
    $photo_url = is_numeric($settings->photo_field)
        ? wp_get_attachment_url($settings->photo_field)
        : $settings->photo_field;

    if (!empty($photo_url)) {
        $text_field   = !empty($settings->text_field) ? $settings->text_field : '';
        $editor_field = !empty($settings->editor_field) ? $settings->editor_field : '';

        echo '<div class="img-roof" style="background-image: url(' . esc_url($photo_url) . ');">';
        echo '<div class="content"><h2>' . esc_html($text_field) . '</h2>';
        echo '<div class="description">' . wp_kses_post($editor_field) . '</div>';
        echo '</div></div>';
    }
}
?>



<?php if ( ! empty( $settings->items ) ) : ?>
    <ul class="list-services">
        <?php foreach ( $settings->items as $item ) : ?>
            <li>
                <a target="_bnalnk" href="<?php echo esc_url( $item->link ); ?>" target="<?php echo esc_attr( $item->link_target ?: '_self' ); ?>">
                    <div class="icon">
    <?php
    if ( ! empty( $item->icon_src ) ) {
        $svg_url = $item->icon_src;
        $svg_path = str_replace( wp_get_upload_dir()['baseurl'], wp_get_upload_dir()['basedir'], $svg_url );

        if ( file_exists( $svg_path ) ) {
            echo file_get_contents( $svg_path );
        }
    }
    ?>
</div>

                    <h3><?php echo esc_html( $item->title ); ?></h3>
                    <div class="description"><?php echo esc_html( $item->description ); ?></div>
                    Learn More <i class="fas fa-angle-right"></i>
                </a>
            </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>





</section>


<script  src="<?php echo esc_url($module->url . 'js/az-pillar.js'); ?>"></script>   