<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$place        = urlencode($settings->place_name);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-map.css'); ?>" />



<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<div class="map-embed-wrapper">
    <iframe
        width="100%"
        height="100%"
        style="border:0"
        loading="lazy"
        allowfullscreen
        referrerpolicy="no-referrer-when-downgrade"
        src="https://www.google.com/maps?q=<?php echo $place; ?>&output=embed">
    </iframe>
</div>

</section>

<script src="<?php echo esc_url($module->url . 'js/az-map.js'); ?>"></script>
