<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Map extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Map Embed', 'fl-builder'),
            'description'     => __('Embed a Google Map by place name.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'location.svg',
        ]);
    }
}

FLBuilder::register_module('AZ_Map', [
    'settings' => [
        'title' => __('Map Settings', 'fl-builder'),
        'sections' => [
            'general' => [
                'title' => __('General Settings', 'fl-builder'),
                'fields' => [
                    'place_name' => [
                        'type'        => 'text',
                        'label'       => __('Place Name or Address', 'fl-builder'),
                        'default'     => 'Eiffel Tower, Paris',
                        'placeholder' => 'Enter a place or address...',
                    ],
                    'map_height' => [
    'type'        => 'text',
    'label'       => __('Map Height (px)', 'fl-builder'),
    'default'     => '400',
    'responsive'  => true,
    'units'       => ['px', 'vh', 'em'],
    'preview'     => [
        'type'     => 'css',
        'selector' => '.az-map-embed',
        'property' => 'height',
        'unit'     => 'px',
    ],
],

                ],
            ],
        ],
    ],
]);
