<?php
if ( ! defined('ABSPATH') ) exit;

/** @var FLBuilderModule $module */
$st = $module->settings ?? (object)[];

$cols   = max(1, (int)($st->columns ?? 3));
$speed  = max(6, (int)($st->speed ?? 25)); // sanity

// Normalize images from Multiple Photos field to URLs
function azlmv_img_url($item){
  if (is_numeric($item)) {
    $u = wp_get_attachment_image_url((int)$item, 'full'); if ($u) return $u;
  }
  if (is_string($item) && filter_var($item, FILTER_VALIDATE_URL)) return $item;
  if (is_array($item)) {
    foreach (['url','src','image','image_src','photo','photo_url'] as $k) {
      if (!empty($item[$k]) && filter_var($item[$k], FILTER_VALIDATE_URL)) return $item[$k];
    }
    foreach (['id','attachment_id','image_id'] as $k) {
      if (!empty($item[$k]) && is_numeric($item[$k])) {
        $u = wp_get_attachment_image_url((int)$item[$k], 'full'); if ($u) return $u;
      }
    }
  }
  return '';
}

$raw = is_array($st->images ?? null) ? $st->images : [];
$imgs = [];
foreach ($raw as $it) {
  $u = azlmv_img_url($it);
  if ($u) $imgs[] = esc_url($u);
}
if (!$imgs) return;

// Build distinct permutations per column so they don’t look the same
function azlmv_gcd($a,$b){ while($b){ $t=$b; $b=$a%$b; $a=$t; } return abs($a); }
function azlmv_perm($arr,$start,$step){
  $n = count($arr); if ($n<=1) return $arr;
  while (azlmv_gcd($step,$n)!==1) $step++;
  $out=[]; $i=$start%$n;
  for($k=0;$k<$n;$k++){ $out[]=$arr[$i]; $i=($i+$step)%$n; }
  return $out;
}

// Split into N columns of unique order
$columns = [];
for ($i=0;$i<$cols;$i++){
  $columns[$i] = azlmv_perm($imgs, $i, $i+1);
  // For visual contrast, reverse the odd columns (those that will scroll opposite)
  if ($i % 2 === 1) $columns[$i] = array_reverse($columns[$i]);
}

// To avoid blanks with small image counts, repeat each column’s list
$min_items_per_span = 24; // safe default – keeps it tall for 100vh columns
foreach ($columns as $i => $list) {
  $rep = (int)ceil($min_items_per_span / max(1,count($list)));
  $columns[$i] = array_merge(...array_fill(0, $rep, $list));
}

$module_slug = sanitize_html_class($module->slug);
?>







<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module_slug); ?>"
         data-module="az-logo-marquee-vertical"
         data-speed="<?php echo esc_attr($speed); ?>">

  <div class="az-logo-marquee-vertical">
    <div class="marquee-wrapper">
      <div class="container">
        <?php foreach ($columns as $i => $list): ?>
          <?php $dir = ($i % 2 === 0) ? 'to-left' : 'to-right'; ?>
          <div class="marquee-block">
            <div class="marquee-inner <?php echo esc_attr($dir); ?>"
                 style="--az-speed: <?php echo esc_attr($speed); ?>s;">
              <?php
              // IMPORTANT: For a seamless loop with translateY(-50%), we output TWO identical spans
              // Each span contains the same sequence repeated (already long enough).
              ?>
              <span>
                <?php foreach ($list as $url): ?>
                  <div class="marquee-item">
                    <img src="<?php echo esc_url($url); ?>" alt="" loading="lazy" decoding="async" />
                  </div>
                <?php endforeach; ?>
              </span>
              <span>
                <?php foreach ($list as $url): ?>
                  <div class="marquee-item">
                    <img src="<?php echo esc_url($url); ?>" alt="" loading="lazy" decoding="async" />
                  </div>
                <?php endforeach; ?>
              </span>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</section>
