<?php
if ( ! defined('ABSPATH') ) exit;

if ( ! class_exists('FLBuilderModule') ) return;

class AZLogoMarqueeVertical extends FLBuilderModule {
  public function __construct() {
    parent::__construct([
      'name'            => __('AZ Logo Marquee Vertical', 'fl-builder'),
      'description'     => __('Smooth, infinite vertical logo marquee (no JS).', 'fl-builder'),
      'category'        => __('Custom Modules', 'fl-builder'),
      'dir'             => plugin_dir_path(__FILE__),
      'url'             => plugin_dir_url(__FILE__),
      'editor_export'   => true,
      'partial_refresh' => true,
      'icon'            => 'star-filled.svg',
    ]);

    // Enqueue ONLY CSS (no JS)
    add_action('wp_enqueue_scripts', function () {
      $css_rel  = 'css/az-logo-marquee-vertical.css';
      $css_path = trailingslashit($this->dir) . $css_rel;
      if ( file_exists($css_path) ) {
        wp_enqueue_style(
          'az-logo-marquee-vertical',
          trailingslashit($this->url) . $css_rel,
          [],
          filemtime($css_path)
        );
      }
    });
  }
}

/* Module fields */
FLBuilder::register_module('AZLogoMarqueeVertical', [
  'general' => [
    'title' => __('General', 'fl-builder'),
    'sections' => [
      'main' => [
        'title'  => __('Content', 'fl-builder'),
        'fields' => [
          'images' => [
            'type'  => 'multiple-photos',
            'label' => __('Logos', 'fl-builder'),
          ],
          'columns' => [
            'type'    => 'select',
            'label'   => __('Columns'),
            'default' => '3',
            'options' => ['1'=>'1','2'=>'2','3'=>'3','4'=>'4'],
          ],
          'speed' => [
            'type'        => 'text',
            'label'       => __('Speed (seconds for one loop)'),
            'default'     => '25',
            'description' => __('Higher = slower'),
          ],
        ],
      ],
    ],
  ],
]);
