<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$width  = $settings->width;
$height = $settings->height;
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-image-sphere.css'); ?>" />


<style>
    #module-<?php echo esc_attr($module->slug); ?>,
    #module-<?php echo esc_attr($module->slug); ?> .img-bg,
    #module-<?php echo esc_attr($module->slug); ?> .border-radius {
        width: <?php echo esc_attr($width); ?>px;
        height: <?php echo esc_attr($height); ?>px;
    }

    @media (max-width: 768px) {
        #module-<?php echo esc_attr($module->slug); ?>,
        #module-<?php echo esc_attr($module->slug); ?> .img-bg,
        #module-<?php echo esc_attr($module->slug); ?> .border-radius {
            width: <?php echo esc_attr($settings->width_medium); ?>px;
            height: <?php echo esc_attr($settings->height_medium); ?>px;
        }
    }

    @media (max-width: 480px) {
        #module-<?php echo esc_attr($module->slug); ?>,
        #module-<?php echo esc_attr($module->slug); ?> .img-bg,
        #module-<?php echo esc_attr($module->slug); ?> .border-radius {
            width: <?php echo esc_attr($settings->width_responsive); ?>%;
            height: <?php echo esc_attr($settings->height_responsive); ?>px;
        }
    }
</style>


<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<?php
if (!empty($settings->photo_field)) {
    $photo_url = is_numeric($settings->photo_field)
        ? wp_get_attachment_url($settings->photo_field)
        : $settings->photo_field;

    if (!empty($photo_url)) {
        echo '<div class="img-bg" style="background-image: url(' . esc_url($photo_url) . ');"></div>';
    }
}
?>




    <div class="border-radius"></div>
</section>



<script  src="<?php echo esc_url($module->url . 'js/az-image-sphere.js'); ?>"></script>   