<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$layout_class = $settings->layout_direction === 'vertical' ? 'vertical' : 'horizontal';
$show_title = isset($settings->show_title) ? $settings->show_title : 'yes';

?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-icon-group.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

         <div class="az-icon-group-wrapper">
  <div class="az-icon-group-list <?php echo esc_attr($layout_class); ?>">
  <?php foreach ($settings->icon_items as $item): ?>
    <?php
        if (empty($item->icon)) {
            continue;
        }

        $icon_color = !empty($item->icon_color) ? '#' . ltrim($item->icon_color, '#') : '#000';
        $icon_size  = !empty($item->icon_size) ? $item->icon_size : '24px';
        $icon_style = 'color:' . esc_attr($icon_color) . '; font-size:' . esc_attr($icon_size) . ';';
        $title_size = !empty($item->title_size) ? $item->title_size : '18px';
        $icon_spacing = isset($settings->icon_spacing) ? $settings->icon_spacing : '18px';
    ?>
    <div class="az-icon-item <?php echo esc_attr($item->animation); ?>" style="margin:<?php echo esc_attr($icon_spacing); ?>px">
        <?php if (!empty($item->link)) : ?>
            <a href="<?php echo esc_url($item->link); ?>">
        <?php endif; ?>

        <i class="<?php echo esc_attr($item->icon); ?>" style="<?php echo esc_attr($icon_style); ?>"></i>

        <?php if (!empty($item->title) && $show_title === 'yes'): ?>
    <span style="font-size:<?php echo esc_attr($title_size); ?>; color:<?php echo esc_attr($icon_color); ?>;">
        <?php echo esc_html($item->title); ?>
    </span>
<?php endif; ?>


        <?php if (!empty($item->link)) : ?>
            </a>
        <?php endif; ?>
    </div>
<?php endforeach; ?>


  </div>
</div>
    </section>


<script  src="<?php echo esc_url($module->url . 'js/az-icon-group.js'); ?>"></script>   