<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Icon_Group extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Icon Group', 'fl-builder'),
            'description'     => __('Display a group of icons with optional animation and layout control.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'list.svg',
        ]);
    }
}


// Register module settings
FLBuilder::register_module('AZ_Icon_Group', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [

            'layout_section' => [
                'title'  => __('Layout', 'fl-builder'),
                'fields' => [
                    'layout_direction' => [
                        'type'    => 'select',
                        'label'   => __('Icon Layout Direction', 'fl-builder'),
                        'default' => 'horizontal',
                        'options' => [
                            'horizontal' => __('Horizontal', 'fl-builder'),
                            'vertical'   => __('Vertical', 'fl-builder'),
                        ],
                    ],
                ],
            ],

            'title_visibility' => [
                'title'  => __('Title Visibility', 'fl-builder'),
                'fields' => [
                    'show_title' => [
                        'type'    => 'select',
                        'label'   => __('Show Icon Title', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                    ],
                ],
            ],

            'icon_spacing' => [
    'title'  => __('Margin', 'fl-builder'),
    'fields' => [
        'icon_spacing' => [ // ✅ field key added here
            'type'    => 'unit',
            'label'   => __('Icon Spacing', 'fl-builder'),
            'default' => '20',
            'units'   => ['px', 'em', 'rem'],
        ],
    ],
],



            'icons_section' => [
                'title'  => __('Icon Items', 'fl-builder'),
                'fields' => [
                    'icon_items' => [
                        'type'         => 'form',
                        'label'        => __('Icons', 'fl-builder'),
                        'form'         => 'az_icon_item_form',
                        'preview_text' => 'title',
                        'multiple'     => true,
                    ],
                ],
            ],
        ],
    ],
]);

// Register the repeater form
FLBuilder::register_settings_form('az_icon_item_form', [
    'title' => __('Icon Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'icon_settings' => [
                    'title'  => '',
                    'fields' => [
                        'title' => [
                            'type'  => 'text',
                            'label' => __('Label', 'fl-builder'),
                        ],
                        'title_size' => [
                        'type'    => 'unit',
                        'label'   => __('Font Size Title', 'fl-builder'),
                        'default' => '18',
                        'units'   => ['px', 'em', 'rem'],
                        ],
                        'icon' => [
                            'type'  => 'icon',
                            'label' => __('Icon', 'fl-builder'),
                        ],
                        'icon_color' => [
                        'type'  => 'color',
                        'label' => __('Icon Color', 'fl-builder'),
                        'default' => '#000000',
                        ],

                        'icon_size' => [
                        'type'    => 'unit',
                        'label'   => __('Icon Size', 'fl-builder'),
                        'default' => '24',
                        'units'   => ['px', 'em', 'rem'],
                        ],

                        'link' => [
                            'type'  => 'link',
                            'label' => __('Link (optional)', 'fl-builder'),
                        ],
                        'animation' => [
                            'type'    => 'select',
                            'label'   => __('Hover Animation', 'fl-builder'),
                            'default' => '',
                            'options' => [
                                ''        => __('None', 'fl-builder'),
                                'fade'    => __('Fade', 'fl-builder'),
                                'grow'    => __('Grow', 'fl-builder'),
                                'rotate'  => __('Rotate', 'fl-builder'),
                            ],
                        ],
                    ],
                ],
            ],
        ],
    ],
]);