<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);

// Collect categories
$categories = [];

foreach ($settings->gallery_images as $image_id) {
    $category = get_post_meta($image_id, 'category', true);
    if (!empty($category)) {
        $categories[] = sanitize_title($category);
    }
}

$unique_categories = array_unique($categories);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-gallery.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

    <?php if (!empty($settings->gallery_images)) : ?>
        <div class="az-gallery-wrapper">
            
            <!-- Filter Buttons -->
            <?php if ($settings->disable_filtering !== 'true') : ?>
    <!-- Filter Buttons -->
    <div class="filter-scroll-wrapper">
        <ul class="filters filter-button-group">
            <li class="active" data-filter="*"><?php _e('All', 'fl-builder'); ?></li>
            <?php foreach ($unique_categories as $cat) : ?>
                <li data-filter="<?php echo esc_attr($cat); ?>">
                    <?php echo esc_html(ucfirst($cat)); ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>


            <!-- Gallery Grid -->
            <div id="container" class="grid">
                <?php foreach ($settings->gallery_images as $image_id) : ?>
                    <?php
                    $img_url = wp_get_attachment_url($image_id);
                    $category = get_post_meta($image_id, 'category', true);
                    $caption = get_the_excerpt($image_id);
                    $filter = sanitize_html_class($category ?: 'uncategorized');
                    ?>
                    <?php if ($img_url): ?>
                        <div class="grid-item <?php echo esc_attr($filter); ?>" data-filter="<?php echo esc_attr($filter); ?>">
                            <a class="popupimg" href="<?php echo esc_url($img_url); ?>">
                                <div class="bg-image" style="background-image: url('<?php echo esc_url($img_url); ?>');"></div>
                                <div class="overlay"><?php echo esc_html($caption); ?></div>
                            </a>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <!-- Pagination injected by JS -->
            <div class="isotope-pager"></div>
        </div>
    <?php endif; ?>

</section>

<script src="<?php echo esc_url($module->url . 'js/az-gallery.js'); ?>"></script>
