<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Gallery_Module extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Gallery', 'fl-builder'),
            'description'     => __('Portfolio Gallery Filter With Pagination Responsive', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'format-gallery.svg',
        ]);

        // Ensure scripts/styles load properly
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    public function enqueue_scripts() {
        // Isotope
        wp_enqueue_script(
            'isotope-pkgd',
            get_stylesheet_directory_uri() . '/js/isotope.pkgd.min.js',
            array('jquery'),
            '3.0.6',
            true
        );

        // Magnific Popup
        wp_enqueue_script(
            'magnific-popup',
            get_stylesheet_directory_uri() . '/js/jquery.magnific-popup.js',
            array('jquery'),
            '1.1.0',
            true
        );

        wp_enqueue_style(
            'magnific-popup-style',
            get_stylesheet_directory_uri() . '/css/magnific-popup.css',
            array(),
            '1.1.0'
        );
    }
}

// Register the module
FLBuilder::register_module('AZ_Gallery_Module', [
    'general' => [
        'title'    => __('Gallery Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Main Settings', 'fl-builder'),
                'fields' => [
    'gallery_images' => [
        'type'        => 'multiple-photos',
        'label'       => __('Select Images', 'fl-builder'),
        'help'        => __('Choose the images to display in the gallery.', 'fl-builder'),
    ],
    'disable_filtering' => [
        'type'        => 'select',
        'label'       => __('Disable Filtering', 'fl-builder'),
        'default'     => 'false',
        'options'     => [
            'false' => __('No', 'fl-builder'),
            'true'  => __('Yes', 'fl-builder'),
        ],
        'description' => __('Choose whether to hide the category filter buttons.', 'fl-builder'),
    ],
],

            ],
        ],
    ],
    
]);
