<?php

/**
 * @class FLAZFlipGridModuleSwap
 */
class FLAZFlipGridModuleSwap extends FLBuilderModule {

	public function __construct() {
		parent::__construct([
			'name'            => __('AZ Flip Grid Swap', 'fl-builder'),
			'description'     => __('A flip box grid module with Swap Image', 'fl-builder'),
			'category'        => __('Custom Modules', 'fl-builder'),
			'dir'             => plugin_dir_path(__FILE__),
			'url'             => plugin_dir_url(__FILE__),
			'editor_export'   => true,
			'enabled'         => true,
			'partial_refresh' => true,
		]);

		$this->add_css('az-flip-grid-swap');
	}

	public function enqueue_scripts() {
		// If you have custom scripts
	}
}

// Register the module
FLBuilder::register_module('FLAZFlipGridModuleSwap', [
	'general' => [
		'title' => __('General', 'fl-builder'),
		'sections' => [
			'general_settings' => [
				'title'  => __('General Settings', 'fl-builder'),
				'fields' => [
					'columns' => [
						'type'    => 'select',
						'label'   => __('Columns', 'fl-builder'),
						'default' => '3',
						'options' => [
							'2' => __('2 Columns', 'fl-builder'),
							'3' => __('3 Columns', 'fl-builder'),
							'4' => __('4 Columns', 'fl-builder'),
							'5' => __('5 Columns', 'fl-builder'),
						],
					],
					'color_field_heading' => [
						'type'    => 'color',
						'label'   => __('Heading Color', 'fl-builder'),
						'default' => '#ff0000',
					],
					'color_field_description' => [
						'type'    => 'color',
						'label'   => __('Description Color', 'fl-builder'),
						'default' => '#ff0000',
					],
                    'color_field_background' => [
						'type'    => 'color',
						'label'   => __('Background Color', 'fl-builder'),
						'default' => '#ff0000',
					],
				],
			],
		],
	],

	'items' => [
	'title' => __('Items', 'fl-builder'),
	'sections' => [
		'item_fields' => [
			'title'  => __('Flip Cards', 'fl-builder'),
			'fields' => [
				'items' => [
					'type'         => 'form',
					'label'        => __('Card Items', 'fl-builder'),
					'form'         => 'az_flip_grid_item_form',
					'preview_text' => 'title',
					'multiple'     => true,
				],
			],
		],
	],
],

]);

// Register sub form for repeater
FLBuilder::register_settings_form('az_flip_grid_item_form', [
	'title' => __('Card Item', 'fl-builder'),
	'tabs'  => [
		'general' => [
			'title'    => __('General', 'fl-builder'),
			'sections' => [
				'main' => [
					'title'  => '',
					'fields' => [
						'title' => [
							'type'  => 'text',
							'label' => __('Title', 'fl-builder'),
						],
						'description' => [
							'type'  => 'textarea',
							'label' => __('Description', 'fl-builder'),
						],
						'image_src' => [
	'type'  => 'photo',
	'label' => __('Image', 'fl-builder'),
],
'image_hover' => [
	'type'  => 'photo',
	'label' => __('Hover Image', 'fl-builder'),
],

						'link' => [
							'type'  => 'link',
							'label' => __('Link', 'fl-builder'),
						],
						'style_type' => [
							'type'    => 'select',
							'label'   => __('Card Style', 'fl-builder'),
							'default' => 'style1',
							'options' => [
								'style1' => __('Style One', 'fl-builder'),
								'style2' => __('Style Two', 'fl-builder'),
							],
						],
					],
				],
			],
		],
	],
]);

