<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);

// Build array for JS
$testimonials = [];

if (!empty($settings->manual_testimonials)) {
    foreach ($settings->manual_testimonials as $item) {
        $photo = is_numeric($item->photo)
            ? wp_get_attachment_url($item->photo)
            : esc_url($item->photo);

        $testimonials[] = [
            'quote'       => wp_kses_post($item->description),
            'name'        => esc_html($item->name),
            'designation' => '', // Add this to the module if needed
            'src'         => esc_url($photo),
            'link'        => esc_url($item->link_url),
        ];
    }
}
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-circular-slider.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">


         <?php if (!empty($settings->nav_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .arrow-button {
        background-color: #<?php echo esc_attr($settings->bg_color); ?> ;
    }
    #module-<?php echo esc_attr($module->slug); ?> button {
      color: #<?php echo esc_attr($settings->nav_color); ?> !important;
    }
  </style>
<?php endif; ?>

<?php if (!empty($settings->nav_hover_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .arrow-button:hover {
        background-color: #<?php echo esc_attr($settings->bg_hover_color); ?> ;
    }
    #module-<?php echo esc_attr($module->slug); ?> button:hover {
      color: #<?php echo esc_attr($settings->nav_hover_color); ?> !important;
    }
  </style>
<?php endif; ?>


    <div class="testimonial-container">
        <div class="testimonial-grid">
            <div class="image-container" id="image-container"></div>
            <div class="testimonial-content">
                <div>
                    <h3 class="name" id="name"></h3>
                    <p class="designation" id="designation"></p>
                    <p class="quote" id="quote"></p>
                </div>
                <div class="arrow-buttons">
                    <button class="arrow-button prev-button" id="prev-button">
                        <i class="<?php echo esc_attr($settings->nav_icon_left); ?>"></i>
                    </button>
                    <button class="arrow-button next-button" id="next-button">
                        <i class="<?php echo esc_attr($settings->nav_icon_right); ?>"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.azCircularTestimonials = <?php echo wp_json_encode($testimonials); ?>;
    </script>
</section>

