<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Circular_Slider extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Circular Slider', 'fl-builder'),
            'description'     => __('Circular Animated Testimonials', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'slides.svg',
        ]);
    }

    public function enqueue_scripts() {
        wp_enqueue_script(
            'gsap-js',
            get_stylesheet_directory_uri() . '/js/gsap.min.js',
            [],
            '8.4.5',
            true
        );

        wp_enqueue_script(
            'az-circular-init',
            $this->url . 'js/az-circular-slider.js',
            ['gsap-js'],
            '1.0.0',
            true
        );
    }
}

// Register the manual testimonial item form
FLBuilder::register_settings_form('az_testimonial_manual_item_form', [
    'title' => __('Manual Testimonial Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'name' => [
                            'type'  => 'text',
                            'label' => __('Name', 'fl-builder'),
                        ],
                        'description' => [
                            'type'  => 'editor',
                            'label' => __('Description', 'fl-builder'),
                        ],
                        'photo' => [
                            'type'  => 'photo',
                            'label' => __('Photo', 'fl-builder'),
                        ],
                        'link_url' => [
                            'type'  => 'link',
                            'label' => __('Link URL', 'fl-builder'),
                        ],
                    ]
                ]
            ]
        ]
    ]
]);

// Register the module with manual testimonial input only
FLBuilder::register_module('AZ_Circular_Slider', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [
                    'manual_testimonials' => [
                        'type'         => 'form',
                        'label'        => __('Testimonials (Manual)', 'fl-builder'),
                        'form'         => 'az_testimonial_manual_item_form',
                        'preview_text' => 'name',
                        'multiple'     => true,
                        'connections'  => [],
                    ],

                    'nav_icon_left' => [
                        'type'    => 'icon',
                        'label'   => __('Left Arrow Icon', 'fl-builder'),
                        'default' => 'fa fa-chevron-left',
                    ],
                    'nav_icon_right' => [
                        'type'    => 'icon',
                        'label'   => __('Right Arrow Icon', 'fl-builder'),
                        'default' => 'fa fa-chevron-right',
                    ],
                    'nav_color' => [
                        'type'       => 'color',
                        'label'      => __('Arrow Color', 'fl-builder'),
                        'default'    => '#333333',
                        'show_reset' => true,
                    ],
                    'nav_hover_color' => [
                        'type'       => 'color',
                        'label'      => __('Arrow Hover Color', 'fl-builder'),
                        'default'    => '#1d9fd9',
                        'show_reset' => true,
                    ],
                    'bg_color' => [
                        'type'       => 'color',
                        'label'      => __('Background Color', 'fl-builder'),
                        'default'    => '#1d9fd9',
                        'show_reset' => true,
                    ],
                    'bg_hover_color' => [
                        'type'       => 'color',
                        'label'      => __('Background Hover Color', 'fl-builder'),
                        'default'    => '#1d9fd9',
                        'show_reset' => true,
                    ],
                ],
            ],
        ],
    ],
]);
