<?php
$settings      = $module->settings;
$color_mode    = $settings->color_mode ?? 'solid';
$solid         = $settings->solid_color ?? '#00B4DB';
$start         = $settings->gradient_start ?? '#00B4DB';
$middle        = $settings->gradient_middle ?? '#224488';
$end           = $settings->gradient_end ?? '#0083B0';
$gradient_id   = 'grad-' . esc_attr($module->node);
$transform     = $settings->transform_option ?? ''; // e.g., rotate, flip
$transform_class = '';

switch ($transform) {
  case 'rotate-180':
      $transform_class = 'transform-rotate';
      break;
  case 'flip-horizontal':
      $transform_class = 'transform-flip-x';
      break;
  case 'flip-vertical':
      $transform_class = 'transform-flip-y';
      break;
}


?>


<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-animation-wave.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

         <div class="waves <?php echo esc_attr($transform_class); ?>">
  <svg
    width="100%"
    height="200px"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    style="<?php echo esc_attr($transform); ?>"
  >
    <defs>
      <linearGradient id="<?php echo $gradient_id; ?>" x1="0%" y1="0%" x2="100%" y2="0%">
        <stop offset="0%" stop-color="#<?php echo esc_attr($start); ?>" />
        <stop offset="50%" stop-color="#<?php echo esc_attr($middle); ?>" />
        <stop offset="100%" stop-color="#<?php echo esc_attr($end); ?>" />
      </linearGradient>
    </defs>

    <path
      fill="<?php echo ($color_mode === 'gradient') ? 'url(#' . $gradient_id . ')' : esc_attr($solid); ?>"
      d="
        M0 67
        C 273,183
          822,-40
          1920.00,106 
        V 359 
        H 0 
        V 67
        Z
      "
    >
      <animate
        repeatCount="indefinite"
        attributeName="d"
        dur="15s"
        attributeType="XML"
        values="
          M0 77 C 473,283 822,-40 1920,116 V 359 H 0 V 67 Z;
          M0 77 C 473,-40 1222,283 1920,136 V 359 H 0 V 67 Z;
          M0 77 C 973,260 1722,-53 1920,120 V 359 H 0 V 67 Z;
          M0 77 C 473,283 822,-40 1920,116 V 359 H 0 V 67 Z
        "
      />
    </path>
  </svg>
</div>


    </section>


<script  src="<?php echo esc_url($module->url . 'js/az-animation-wave.js'); ?>"></script>   