<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Animation_Wave extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Animation Wave', 'fl-builder'),
            'description'     => __('A clean starter module.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
        ]);
    }
}

FLBuilder::register_module('AZ_Animation_Wave', [
    'settings' => [
        'title' => __('Wave Settings', 'fl-builder'),
        'sections' => [
            'general' => [
                'title' => __('General Settings', 'fl-builder'),
                'fields' => [
                    'color_mode' => [
                        'type'    => 'select',
                        'label'   => __('Color Mode', 'fl-builder'),
                        'default' => 'solid',
                        'options' => [
                            'solid'    => __('Solid', 'fl-builder'),
                            'gradient' => __('Gradient', 'fl-builder'),
                        ],
                        'toggle' => [
                            'solid' => [
                                'fields' => ['solid_color'],
                            ],
                            'gradient' => [
                                'fields' => ['gradient_start', 'gradient_middle', 'gradient_end'],
                            ],
                        ],
                    ],
                    'solid_color' => [
                        'type'  => 'color',
                        'label' => __('Solid Color', 'fl-builder'),
                    ],
                    'gradient_start' => [
                        'type'  => 'color',
                        'label' => __('Gradient Start', 'fl-builder'),
                    ],
                    'gradient_middle' => [
                        'type'  => 'color',
                        'label' => __('Gradient Middle', 'fl-builder'),
                    ],
                    'gradient_end' => [
                        'type'  => 'color',
                        'label' => __('Gradient End', 'fl-builder'),
                    ],
                    'transform_option' => [
                        'type'    => 'select',
                        'label'   => __('Wave Transform', 'fl-builder'),
                        'default' => '',
                        'options' => [
                            ''               => __('None', 'fl-builder'),
                            'rotate-180'     => __('Rotate 180°', 'fl-builder'),
                            'flip-horizontal'=> __('Flip Horizontal', 'fl-builder'),
                            'flip-vertical'  => __('Flip Vertical', 'fl-builder'),
                        ],
                    ],
                ],
            ],
        ],
    ],
]);

