<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$accordion_id = 'az-accordion-' . $module->node;
$one_open     = isset($settings->one_open) && $settings->one_open === 'yes';
$open_first   = isset($settings->open_first) && $settings->open_first === 'yes';
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-accordion.css'); ?>" />

<section id="<?php echo esc_attr($accordion_id); ?>"
         class="az-accordion-wrapper <?php echo esc_attr($module_slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>"
         data-one-open="<?php echo $one_open ? 'yes' : 'no'; ?>"
         data-open-first="<?php echo $open_first ? 'yes' : 'no'; ?>">

    <?php if (!empty($settings->items)) : ?>
        <div class="az-accordion">
            <?php foreach ($settings->items as $index => $item) : ?>
                <?php
                    $is_open = $open_first && $index === 0;
                    $icon_url = isset($item->icon) && !empty($item->icon) ? $item->icon : '';
                ?>
                <div class="az-accordion-item <?php echo $is_open ? 'active' : ''; ?>">
                    <div class="az-accordion-header <?php echo $is_open ? 'active' : ''; ?>" data-index="<?php echo esc_attr($index); ?>">
                        <?php if ($icon_url): ?>
                            <img src="<?php echo esc_url($icon_url); ?>" alt="icon" class="az-accordion-icon" />
                        <?php endif; ?>
                        <?php echo esc_html($item->title); ?>
                    </div>
                    <div class="az-accordion-body <?php echo $is_open ? 'open' : ''; ?>">
                        <?php echo apply_filters('the_content', $item->content); ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

</section>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const wrapper = document.querySelector('#<?php echo esc_js($accordion_id); ?>');
    const headers = wrapper.querySelectorAll('.az-accordion-header');
    const oneOpen = wrapper.dataset.oneOpen === 'yes';
    const items = wrapper.querySelectorAll('.az-accordion-item');

    headers.forEach(header => {
        header.addEventListener('click', () => {
            const currentItem = header.parentElement;
            const currentBody = header.nextElementSibling;
            const isOpen = currentItem.classList.contains('active');

            if (oneOpen) {
                // Close all items
                items.forEach(item => {
                    item.classList.remove('active');
                    item.querySelector('.az-accordion-header').classList.remove('active');
                    item.querySelector('.az-accordion-body').classList.remove('open');
                });
            }

            // If the current item was not already open, open it
            if (!isOpen) {
                currentItem.classList.add('active');
                header.classList.add('active');
                currentBody.classList.add('open');
            }
        });
    });

    // Open first item if "Open First" is enabled
    if (wrapper.dataset.openFirst === 'yes') {
        const firstItem = items[0];
        const firstHeader = firstItem.querySelector('.az-accordion-header');
        const firstBody = firstItem.querySelector('.az-accordion-body');
        firstItem.classList.add('active');
        firstHeader.classList.add('active');
        firstBody.classList.add('open');
    }
});
</script>

