<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
	return;
}

class AZ_Accordion_Module extends FLBuilderModule {
	public function __construct() {
		parent::__construct([
			'name'            => __('AZ Accordion', 'fl-builder'),
			'description'     => __('A simple accordion module.', 'fl-builder'),
			'category'        => __('Custom Modules', 'fl-builder'),
			'dir'             => plugin_dir_path(__FILE__),
			'url'             => plugin_dir_url(__FILE__),
			'editor_export'   => true,
			'enabled'         => true,
			'partial_refresh' => true,
			'icon'            => 'layout.svg',
		]);

		$this->add_css('az-accordion');
	}
}

// Register the repeater form for accordion items
FLBuilder::register_settings_form('az_accordion_item_form', [
	'title' => __('Accordion Item', 'fl-builder'),
	'tabs'  => [
		'general' => [
			'title'    => __('General', 'fl-builder'),
			'sections' => [
				'main' => [
					'title'  => '',
					'fields' => [
						'title'   => [
							'type'  => 'text',
							'label' => __('Title', 'fl-builder'),
							'required' => true,
						],
						'icon' => [
							'type'  => 'photo',
							'label' => __('Icon (optional)', 'fl-builder'),
						],
						'content' => [
							'type'  => 'editor',
							'label' => __('Content', 'fl-builder'),
							'rows'  => 5,
						],
					],
				],
			],
		],
	],
]);

// Register the module itself
FLBuilder::register_module('AZ_Accordion_Module', [
	'settings' => [
		'title'    => __('Accordion Settings', 'fl-builder'),
		'sections' => [
			'behavior' => [
				'title'  => __('Behavior', 'fl-builder'),
				'fields' => [
					'one_open' => [
						'type'    => 'select',
						'label'   => __('Allow only one open?', 'fl-builder'),
						'default' => 'yes',
						'options' => [
							'yes' => __('Yes', 'fl-builder'),
							'no'  => __('No', 'fl-builder'),
						],
					],
					'open_first' => [
						'type'    => 'select',
						'label'   => __('Open first item by default?', 'fl-builder'),
						'default' => 'yes',
						'options' => [
							'yes' => __('Yes', 'fl-builder'),
							'no'  => __('No', 'fl-builder'),
						],
					],
				],
			],
			'content' => [
				'title'  => __('Accordion Items', 'fl-builder'),
				'fields' => [
					'items' => [
						'type'         => 'form',
						'label'        => __('Accordion Items', 'fl-builder'),
						'form'         => 'az_accordion_item_form',
						'preview_text' => 'title',
						'multiple'     => true,
					],
				],
			],
		],
	],
]);
