<?php
/* Template Name: Custom Order History Page */
get_header();

if (!is_user_logged_in()) {
    wp_redirect(wp_login_url());
    exit;
}

$current_user_id = get_current_user_id();
$customer_orders = wc_get_orders(array(
    'customer_id' => $current_user_id,
    'limit' => -1,
    'orderby' => 'date',
    'order' => 'DESC',
));
?>

<div class="custom-order-history">
    <div class="custom-order-history__container">
        <h1 class="custom-order-history__title">ORDER HISTORY</h1>

        <?php if ($customer_orders): ?>
            <?php foreach ($customer_orders as $order):
                $items = $order->get_items();
                $delivery_date = $order->get_date_created()->format('d M Y');
                $order_number = $order->get_order_number();
                $total = $order->get_total();
            ?>

            <?php foreach ($items as $item):
                $product = $item->get_product();
                $product_image = wp_get_attachment_image_src($product->get_image_id(), 'medium')[0];
                $product_name = $item->get_name();
                $product_price = wc_price($item->get_total());
                $shipping = $order->get_address('shipping');
                $note = $order->get_customer_note();
            ?>
            <div class="custom-order-history__item">
                <div class="custom-order-history__image">
                    <img src="<?php echo esc_url($product_image); ?>" alt="<?php echo esc_attr($product_name); ?>" />
                </div>
                <div class="custom-order-history__details">
                    <h3 class="custom-order-history__section-title">ORDER DETAILS</h3>
                    <p class="custom-order-history__text"><strong><?php echo esc_html($product_name); ?><br><?php echo $product_price; ?></strong></p>
					<form method="post" action="<?php echo esc_url( wc_get_cart_url() ); ?>">
    <input type="hidden" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>">
    <button type="submit" class="button alt" style="font-size: 12px; margin-top: 10px;">Re-order</button>
</form>

                    <h3 class="custom-order-history__section-title">DELIVER TO</h3>
                    <p class="custom-order-history__text">
                        <?php echo esc_html($shipping['address_1'] . ', ' . $shipping['city'] . ', ' . $shipping['postcode'] . ', ' . $shipping['state'] . ', ' . $shipping['country']); ?>
                    </p>

                    <h3 class="custom-order-history__section-title">NOTE:</h3>
                    <p class="custom-order-history__text"><?php echo esc_html($note ?: '-'); ?></p>
                </div>
                <div class="custom-order-history__meta">
                    <h3 class="custom-order-history__section-title">ORDER NUMBER</h3>
                    <p class="custom-order-history__text">#<?php echo $order_number; ?></p>

                    <h3 class="custom-order-history__section-title">DELIVERY DATE</h3>
                    <p class="custom-order-history__text"><strong><?php echo $delivery_date; ?></strong></p>

                    <h3 class="custom-order-history__section-title">TOTAL</h3>
                    <p class="custom-order-history__text"><strong><?php echo wc_price($total); ?></strong></p>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No orders found.</p>
        <?php endif; ?>
    </div>
</div>
<style>
.custom-order-history {
    font-family: 'PT Sans', sans-serif;
	font-weight: bolder;
}

.custom-order-history h3 {
    font-family: 'PT Sans', sans-serif !important;
	font-weight: normal;
}
.custom-order-history__container {
    max-width: 1080px;
    margin: 30px auto;
    padding: 0 20px;
}

.custom-order-history__title {
    font-family: 'Cormorant Garamond', sans-serif;
    font-size: 32px;
	font-weight: bolder;
    margin-bottom: 40px;
	text-align: center;
}

.custom-order-history__item {
    display: flex;
    gap: 20px;
    margin-bottom: 60px;
    align-items: flex-start;
    border-bottom: 1px solid #eee;
    padding-bottom: 30px;
    flex-wrap: wrap;
}

.custom-order-history__image {
    flex: 1 1 30%;
}

.custom-order-history__image img {
    max-width: 100%;
    border-radius: 8px;
}

.custom-order-history__details,
.custom-order-history__meta {
    flex: 1 1 30%;
    text-align: left;
}

.custom-order-history__section-title {
    color: #b6b6b6;
    font-size: 16px;
    margin-top: 20px;
    margin-bottom: 10px;
    text-align: left;
    font-weight: 600;
}

.custom-order-history__text {
    font-size: 13px;
    margin-bottom: 10px;
}
.custom-order-history__details .button.alt {
    background: #222;
    color: #fff;
    padding: 6px 12px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}
.custom-order-history__details .button.alt:hover {
    background: #000;
}


</style>
<?php get_footer(); ?>
