<?php
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('hello-elementor-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('hello-elementor-child-style', get_stylesheet_uri());
});

add_action('admin_post_nopriv_custom_user_registration', 'handle_custom_user_registration');
function handle_custom_user_registration() {
    $email = sanitize_email($_POST['user_email']);
    $password = sanitize_text_field($_POST['user_pass']);

    $username = explode('@', $email)[0];
    $userdata = [
        'user_login' => $username,
        'user_email' => $email,
        'user_pass'  => $password,
    ];

    $user_id = wp_insert_user($userdata);

    if (!is_wp_error($user_id)) {
        wp_redirect(home_url('/login?registered=1'));
        exit;
    } else {
        wp_redirect(home_url('/sign-up?error=1'));
        exit;
    }
}


function load_dashicons_front_end() {
    wp_enqueue_style( 'dashicons' );
}
add_action( 'wp_enqueue_scripts', 'load_dashicons_front_end' );


function override_google_fonts_fix() {
    wp_enqueue_style(
        'custom-google-fonts',
        'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@400;500;600&family=Mulish:wght@400;500&display=swap',
        false
    );
}
add_action('wp_enqueue_scripts', 'override_google_fonts_fix', 99);





