<?php
/**
 * Plugin Name: YITH Compare Button Shortcode FINAL
 * Description: Adds product to YITH compare then opens comparison table in new tab with loading effect.
 * Version: 1.6
 * Author: ChatGPT
 */

if (!defined('ABSPATH')) exit;

function yith_add_to_compare_button_shortcode() {
    global $product;

    if (!$product || !is_a($product, 'WC_Product')) return '';

    $product_id = $product->get_id();

    return '
    <div class="custom-compare-container">
        <button class="custom-compare-button" data-product_id="' . esc_attr($product_id) . '">
            ADD TO COMPARE <span>+</span>
        </button>
    </div>

    <style>
        .custom-compare-container {
            text-align: center;
            margin-top: 20px;
        }
        .custom-compare-button {
            display: inline-block;
			font-family: "Open Sans", sans-serif;
			font-size: 15px;
			font-weight: 600;
			text-transform: uppercase;
			color: #000 !important; /* Force black */
			text-decoration: none;
			border: none;
			border-bottom: 2px solid #000; /* Set underline to black */
			padding: 0 0 4px 0;
			background: none;
			cursor: pointer;
			transition: all 0.2s ease;
			box-shadow: none !important; /* Remove pink glow */
			filter: none !important;
			text-shadow: none !important;
			opacity: 1 !important;
        }
        .custom-compare-button span {
            font-weight: bold;
            font-size: 18px;
            margin-left: 5px;
        }
        .custom-compare-button:hover {
            color: #000;
            border-color: #000;
        }
        .custom-compare-button[disabled] {
            color: #bbb;
            border-color: #ddd;
            cursor: not-allowed;
            pointer-events: none;
        }
    </style>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".custom-compare-button").forEach(function (btn) {
            btn.addEventListener("click", function () {
                const productId = btn.getAttribute("data-product_id");
                const addUrl = /?action=yith-woocompare-add-product&id=${productId};
                const originalText = btn.innerHTML;

                // Show loading state
                btn.disabled = true;
                btn.innerHTML = "ADDING...";

                fetch(addUrl, {
                    method: "GET",
                    credentials: "same-origin"
                })
                .then(() => {
                    setTimeout(() => {
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                        window.open("/?action=yith-woocompare-view-table&iframe=yes", "_blank");
                    }, 700);
                })
                .catch(err => {
                    btn.innerHTML = originalText;
                    btn.disabled = false;
                    alert("Failed to add product to compare.");
                    console.error(err);
                });
            });
        });
    });
    </script>
    ';
}
add_shortcode('add_to_compare_button', 'yith_add_to_compare_button_shortcode');