<?php

namespace ShopMagicVendor\Getresponse\Sdk\Operation\Shops\GetShop;

use ShopMagicVendor\Getresponse\Sdk\Client\Operation\QueryOperation;
use ShopMagicVendor\Getresponse\Sdk\OperationVersionTrait;
class GetShop extends QueryOperation
{
    use OperationVersionTrait;
    public const METHOD_URL = '/v3/shops/{shopId}';
    /** @var string */
    private $shopId;
    /** @var GetShopFields */
    private $fields;
    /**
     * @param string $shopId
     */
    public function __construct($shopId)
    {
        $this->shopId = $shopId;
    }
    /**
     * @return string
     */
    public function buildUrlFromTemplate()
    {
        return str_ireplace(['{shopId}'], [$this->shopId], self::METHOD_URL);
    }
    /**
     * @param GetShopFields $fields
     * @return $this
     */
    public function setFields(GetShopFields $fields)
    {
        $this->fields = $fields;
        return $this;
    }
    /**
     * @return string
     */
    public function getUrl()
    {
        $extra = $this->getFieldsParameterArray($this->fields);
        return $this->buildUrlFromTemplate() . $this->buildQueryString(null, null, $extra);
    }
}
