<?php

namespace ShopMagicVendor\Getresponse\Sdk\Operation\Newsletters\Statistics\GetStatistics;

use ShopMagicVendor\Getresponse\Sdk\Client\Operation\Pagination;
use ShopMagicVendor\Getresponse\Sdk\Client\Operation\QueryOperation;
use ShopMagicVendor\Getresponse\Sdk\OperationVersionTrait;
class GetStatistics extends QueryOperation
{
    use OperationVersionTrait;
    public const METHOD_URL = '/v3/newsletters/statistics';
    /** @var GetStatisticsSearchQuery */
    private $query;
    /** @var Pagination */
    private $pagination;
    /** @var GetStatisticsFields */
    private $fields;
    /**
     * @return string
     */
    public function buildUrlFromTemplate()
    {
        return self::METHOD_URL;
    }
    /**
     * @param GetStatisticsSearchQuery $query
     * @return $this
     */
    public function setQuery(GetStatisticsSearchQuery $query)
    {
        $this->query = $query;
        return $this;
    }
    /**
     * @param Pagination $pagination
     * @return $this
     */
    public function setPagination(Pagination $pagination)
    {
        $this->pagination = $pagination;
        return $this;
    }
    /**
     * @param GetStatisticsFields $fields
     * @return $this
     */
    public function setFields(GetStatisticsFields $fields)
    {
        $this->fields = $fields;
        return $this;
    }
    /**
     * @return string
     */
    public function getUrl()
    {
        $extra = array_merge($this->getPaginationParametersArray($this->pagination), $this->getFieldsParameterArray($this->fields));
        return $this->buildUrlFromTemplate() . $this->buildQueryString($this->query, null, $extra);
    }
}
