<?php
declare( strict_types=1 );

namespace WPDesk\ShopMagic\DataSharing;

/**
 * Can provide list of items and render them one by one.
 */
interface RenderableItemProvider {
	/**
	 * Can provide some unknown items that can be iterated.
	 */
	public function get_items(): \Iterator;

	/**
	 * Can render items generated by get_items
	 */
	public function render_item( object $item ): string;
}
