<?php
/**
 * Plugin Name: Order Tracking Shortcode
 * Description: A simple shortcode to track WooCommerce order status using order ID.
 * Version: 1.0
 * Author: ChatGPT
 */

if (!defined('ABSPATH')) exit;

function order_tracking_shortcode() {
    ob_start(); ?>

    <div class="custom-order-tracking">
        <form id="order-tracking-form" method="post">
            <input type="text" name="order_id" placeholder="Enter your order ID" required />
            <button type="submit">TRACK IT</button>
        </form>
        <div id="order-status-result"></div>
    </div>

    <style>
        .custom-order-tracking {
            max-width: 500px;
            margin: 0 auto;
            text-align: center;
        }
        #order-tracking-form input {
            width: 100%;
            padding: 12px;
            margin-top: 10px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        #order-tracking-form button {
            margin-top: 15px;
            padding: 10px 30px;
            background: #2B5F10;
            color: #fff;
            font-weight: bold;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        #order-status-result {
            margin-top: 20px;
            font-size: 16px;
            color: #333;
        }
    </style>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const form = document.getElementById("order-tracking-form");
            form.addEventListener("submit", function(e) {
                e.preventDefault();
                const orderId = form.order_id.value.trim();
                const resultDiv = document.getElementById("order-status-result");
                resultDiv.innerHTML = "Checking order status...";

                fetch("<?php echo admin_url('admin-ajax.php'); ?>", {
                    method: "POST",
                    headers: { "Content-Type": "application/x-www-form-urlencoded" },
                    body: new URLSearchParams({
                        action: "check_order_status",
                        order_id: orderId
                    })
                })
                .then(res => res.text())
                .then(data => resultDiv.innerHTML = data)
                .catch(() => resultDiv.innerHTML = "Something went wrong.");
            });
        });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('order_tracking', 'order_tracking_shortcode');

add_action('wp_ajax_check_order_status', 'handle_order_status_check');
add_action('wp_ajax_nopriv_check_order_status', 'handle_order_status_check');

function handle_order_status_check() {
    $order_id = absint($_POST['order_id']);
    if (!$order_id) {
        echo "Invalid Order ID.";
        wp_die();
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        echo "Order not found.";
        wp_die();
    }

    echo "<strong>Order #$order_id Status:</strong> " . wc_get_order_status_name($order->get_status());
    wp_die();
}
