<?php
/**
 * Plugin Name: LPS Dev
 * Plugin URI:  https://yourwebsite.com
 * Description: Customization code by LPS - Adds a delivery date field to WooCommerce.
 * Version:     1.0.0
 * Author:      LPS
 * Author URI:  https://yourwebsite.com
 * License:     GPL v2 or later
 */

if (!defined('ABSPATH')) {
    exit;
}

define('LPS_DEV_PATH', plugin_dir_path(__FILE__));
define('LPS_DEV_URL', plugin_dir_url(__FILE__));

require_once LPS_DEV_PATH . 'includes/custom.php';
require_once LPS_DEV_PATH . 'includes/wc_customer_export.php';

function lps_dev_enqueue_assets() {
    wp_enqueue_style('lps-custom-css', LPS_DEV_URL . 'assets/custom.css', array(), '6.8a', true);
    wp_enqueue_script('lps-custom-js', LPS_DEV_URL . 'assets/custom.js', array('jquery'), '6.8a', true);
}
add_action('wp_enqueue_scripts', 'lps_dev_enqueue_assets');


add_action( 'template_redirect', 'redirect_woolentor_thankyou_page' );

// emergency fix. we dont know what causing `/woolentor-template/thank-you-page-01`
// temp solution just redirect back as this is the wp correct path
function redirect_woolentor_thankyou_page() {
    // Get full request URI (path + query string)
    $request_uri = $_SERVER['REQUEST_URI'];

    // Match: /woolentor-template/thank-you-page-01/order-received/xxxx
    if ( preg_match( '#^/woolentor-template/thank-you-page-01(/order-received/.+)$#', $request_uri, $matches ) ) {
        $rest_of_path = $matches[1]; // Keep /order-received/xxx

        // Preserve query string if any
        $query_string = $_SERVER['QUERY_STRING'];
        $redirect_url = site_url( '/checkout' . $rest_of_path );
        if ( ! empty( $query_string ) ) {
            $redirect_url .= '?' . $query_string;
        }

        // Redirect
        wp_redirect( $redirect_url, 301 );
        exit;
    }
}
