<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Add menu under WooCommerce
function wcecd_add_admin_menu() {
    add_submenu_page(
        'woocommerce',
        'Export Customer Data',
        'Export Customer Data',
        'manage_woocommerce',
        'wcecd_export_customers',
        'wcecd_display_customer_data'
    );
}
add_action('admin_menu', 'wcecd_add_admin_menu');

// Handle CSV download
function wcecd_download_csv() {
    if (isset($_GET['download_csv']) && $_GET['download_csv'] == '1') {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=customer_data.csv');
        
        $output = fopen('php://output', 'w');
        fputcsv($output, ['Customer Name', 'Email', 'Billing Phone', 'Total Order']);
        
        $orders = wc_get_orders(['limit' => -1]);
        
        foreach ($orders as $order) {
            fputcsv($output, [
                $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
                $order->get_billing_email(),
                $order->get_billing_phone(),
                $order->get_total()
            ]);
        }
        
        fclose($output);
        exit;
    }
}
add_action('admin_init', 'wcecd_download_csv');

// Display customer data
function wcecd_display_customer_data() {
    global $wpdb;

    $orders = wc_get_orders(['limit' => -1]);
    echo '<div class="wrap"><h1>Export Customer Data</h1>';
    echo '<a href="?page=wcecd_export_customers&download_csv=1" class="button button-primary">Download</a>';
    echo '<table class="widefat fixed" cellspacing="0" style="margin-top: 10px;">';
    echo '<thead><tr><th>Customer Name</th><th>Email</th><th>Billing Phone</th><th>Total Order</th></tr></thead>';
    echo '<tbody>';

    foreach ($orders as $order) {
        $name  = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
        $email = $order->get_billing_email();
        $phone = $order->get_billing_phone();
        $total = $order->get_total();
        
        echo '<tr>';
        echo '<td>' . esc_html($name) . '</td>';
        echo '<td>' . esc_html($email) . '</td>';
        echo '<td>' . esc_html($phone) . '</td>';
        echo '<td>' . (wc_price($total)) . '</td>';
        echo '</tr>';
    }

    echo '</tbody></table></div>';
}
