<?php
if (!defined('ABSPATH')) {
    exit;
}

// Add delivery date & personalized message fields on product page
add_action('woocommerce_before_add_to_cart_button', 'lps_add_custom_fields');
function lps_add_custom_fields() {
    echo '<label for="personalized_message">Personalized Message:</label>';
    echo '<textarea id="personalized_message" name="personalized_message" rows="3" required>To: 

From: 

    </textarea>';
	
    echo '<label for="delivery_date">Delivery Date:</label>';
    echo '<input type="date" id="delivery_date" name="delivery_date" required>';
}

// Save custom fields in cart
add_filter('woocommerce_add_cart_item_data', 'lps_save_custom_fields_to_cart', 10, 2);
function lps_save_custom_fields_to_cart($cart_item_data, $product_id) {
    if (isset($_POST['delivery_date'])) {
        $cart_item_data['delivery_date'] = sanitize_text_field($_POST['delivery_date']);
    }
    if (isset($_POST['personalized_message'])) {
        $cart_item_data['personalized_message'] = sanitize_textarea_field($_POST['personalized_message']);
    }
    return $cart_item_data;
}

// Display custom fields in cart & checkout
add_filter('woocommerce_get_item_data', 'lps_display_custom_fields_cart_checkout', 10, 2);
function lps_display_custom_fields_cart_checkout($item_data, $cart_item) {
    if (isset($cart_item['delivery_date'])) {
        $item_data[] = array(
            'name'  => 'Delivery Date',
            'value' => esc_html($cart_item['delivery_date'])
        );
    }
    if (isset($cart_item['personalized_message'])) {
        $item_data[] = array(
            'name'  => 'Personalized Message',
            'value' => nl2br(esc_html($cart_item['personalized_message']))
        );
    }
    return $item_data;
}

// Save custom fields in order meta
add_action('woocommerce_checkout_create_order_line_item', 'lps_add_custom_fields_to_order', 10, 4);
function lps_add_custom_fields_to_order($item, $cart_item_key, $values, $order) {
    if (isset($values['delivery_date'])) {
        $item->add_meta_data('Delivery Date', $values['delivery_date']);
    }
    if (isset($values['personalized_message'])) {
        $item->add_meta_data('Personalized Message', $values['personalized_message']);
    }
}

// Add "Show Shipping Info" checkbox in product edit page
add_action('woocommerce_product_options_general_product_data', 'lps_add_shipping_info_checkbox');
function lps_add_shipping_info_checkbox() {
    woocommerce_wp_checkbox(array(
        'id'          => '_show_shipping_info',
        'label'       => __('Show Shipping Info', 'woocommerce'),
        'description' => __('Check to display the Shipping Info tab.', 'woocommerce'),
    ));
}

// Save checkbox value
add_action('woocommerce_process_product_meta', 'lps_save_shipping_info_checkbox');
function lps_save_shipping_info_checkbox($post_id) {
    $value = isset($_POST['_show_shipping_info']) ? 'yes' : 'no';
    update_post_meta($post_id, '_show_shipping_info', $value);
}

// Add "Shipping Info" tab only if checkbox is checked
add_filter('woocommerce_product_tabs', 'lps_add_shipping_info_tab');
function lps_add_shipping_info_tab($tabs) {
    global $product;
    $show_shipping_info = get_post_meta($product->get_id(), '_show_shipping_info', true);

    if ($show_shipping_info === 'yes') {
        $tabs['shipping_info_tab'] = array(
            'title'    => __('Shipping Info', 'woocommerce'),
            'priority' => 50,
            'callback' => 'lps_display_shipping_info_tab_content'
        );
    }

    return $tabs;
}

// Display content from "product-shipping-info-desc" post
function lps_display_shipping_info_tab_content() {
    $post = get_page_by_path('product-shipping-info-desc', OBJECT, 'page');
    if ($post) {
        echo wpautop($post->post_content);
    }
}

// Add fields on checkout review if missing
add_action('woocommerce_review_order_before_payment', 'lps_add_checkout_custom_inputs_if_missing');
function lps_add_checkout_custom_inputs_if_missing() {
    $missing_fields = false;

    foreach (WC()->cart->get_cart() as $cart_item) {
        if (empty($cart_item['delivery_date']) || empty($cart_item['personalized_message'])) {
            $missing_fields = true;
            break;
        }
    }

    if ($missing_fields) {
        ?>
        <div id="custom-fields-warning" style="border:1px solid #e0a800; padding:15px; margin-bottom:20px;">
            <h3>Please complete the missing fields:</h3>
            <p><label for="fix_delivery_date">Delivery Date:</label><br>
                <input type="date" id="fix_delivery_date" name="fix_delivery_date" required></p>

            <p><label for="fix_personalized_message">Personalized Message:</label><br>
                <textarea id="fix_personalized_message" name="fix_personalized_message" rows="3" required></textarea></p>

            <button type="button" class="button alt" id="update-cart-custom-fields">Update Cart</button>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function () {
                const submitButton = document.querySelector('#place_order');
                const fixButton = document.querySelector('#update-cart-custom-fields');

                if (submitButton) {
                    submitButton.addEventListener('click', function (e) {
                        const delivery = document.querySelector('#fix_delivery_date');
                        const message = document.querySelector('#fix_personalized_message');

                        if (delivery && message && (delivery.value.trim() === '' || message.value.trim() === '')) {
                            e.preventDefault();
                            alert('Please complete the delivery date and personalized message.');
                        }
                    });
                }

                if (fixButton) {
                    fixButton.addEventListener('click', function () {
                        const delivery = document.querySelector('#fix_delivery_date').value;
                        const message = document.querySelector('#fix_personalized_message').value;

                        if (delivery && message) {
                            const form = document.createElement('form');
                            form.method = 'post';
                            form.action = '<?php echo wc_get_cart_url(); ?>';

                            const input1 = document.createElement('input');
                            input1.type = 'hidden';
                            input1.name = 'custom_delivery_date';
                            input1.value = delivery;

                            const input2 = document.createElement('input');
                            input2.type = 'hidden';
                            input2.name = 'custom_personalized_message';
                            input2.value = message;

                            const input3 = document.createElement('input');
                            input3.type = 'hidden';
                            input3.name = 'lps_update_custom_fields';
                            input3.value = '1';

                            form.appendChild(input1);
                            form.appendChild(input2);
                            form.appendChild(input3);

                            document.body.appendChild(form);
                            form.submit();
                        }
                    });
                }
            });
        </script>
        <?php
    }
}

// Handle update and reload cart with custom values
add_action('init', 'lps_handle_cart_custom_field_update');
function lps_handle_cart_custom_field_update() {
    if (isset($_POST['lps_update_custom_fields'])) {
        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            if (!empty($_POST['custom_delivery_date'])) {
                WC()->cart->cart_contents[$cart_item_key]['delivery_date'] = sanitize_text_field($_POST['custom_delivery_date']);
            }
            if (!empty($_POST['custom_personalized_message'])) {
                WC()->cart->cart_contents[$cart_item_key]['personalized_message'] = sanitize_textarea_field($_POST['custom_personalized_message']);
            }
        }
        WC()->cart->set_session();
        wp_safe_redirect(wc_get_checkout_url());
        exit;
    }
}

add_filter('woocommerce_cart_item_name', 'custom_cart_item_inputs_if_missing', 10, 3);
function custom_cart_item_inputs_if_missing($product_name, $cart_item, $cart_item_key) {
    $output = $product_name;

    $needs_message = empty($cart_item['personalized_message']);
    $needs_date    = empty($cart_item['delivery_date']);

    if ($needs_message || $needs_date) {
        $output .= '<div class="custom-cart-fields" style="margin-top: 10px;">';
        $output .= '<form method="post" action="">';
        $output .= wp_nonce_field('update_custom_cart_fields', '_custom_cart_nonce', true, false);
        $output .= '<input type="hidden" name="custom_cart_key" value="' . esc_attr($cart_item_key) . '">';

        if ($needs_message) {
            $output .= '<p><label>Personalized Message:<br>';
            $output .= '<textarea name="custom_personalized_message" rows="2" required></textarea></label></p>';
        }

        if ($needs_date) {
            $output .= '<p><label>Delivery Date:<br>';
            $output .= '<input type="date" name="custom_delivery_date" required></label></p>';
        }

        $output .= '<p><button type="submit" name="submit_custom_fields" class="button">Update</button></p>';
        $output .= '</form></div>';
    }

    return $output;
}

add_action('template_redirect', 'handle_cart_custom_fields_update');
function handle_cart_custom_fields_update() {
    if (
        isset($_POST['submit_custom_fields']) &&
        isset($_POST['custom_cart_key']) &&
        wp_verify_nonce($_POST['_custom_cart_nonce'], 'update_custom_cart_fields')
    ) {
        $cart_key = sanitize_text_field($_POST['custom_cart_key']);

        if (isset(WC()->cart->cart_contents[$cart_key])) {
            $message = isset($_POST['custom_personalized_message']) ? sanitize_textarea_field($_POST['custom_personalized_message']) : '';
            $date = isset($_POST['custom_delivery_date']) ? sanitize_text_field($_POST['custom_delivery_date']) : '';

            if (!empty($message)) {
                WC()->cart->cart_contents[$cart_key]['personalized_message'] = $message;
            }

            if (!empty($date)) {
                WC()->cart->cart_contents[$cart_key]['delivery_date'] = $date;
            }

            WC()->cart->set_session();
        }

        // Redirect to avoid resubmission
        wp_safe_redirect(wc_get_cart_url());
        exit;
    }
}

