<?php
/**
 * Plugin Name: Flowers.com.my Returns Plugin v6
 * Description: Final version with form validation, layout fixes, policy link, image storage, and email alerts.
 * Version: 6.0
 * Author: ChatGPT
 */

if (!defined('ABSPATH')) exit;

function flowers_returns_enqueue_scripts() {
    wp_enqueue_style('flowers-returns-style', plugin_dir_url(__FILE__) . 'style.css');
    wp_enqueue_script('google-recaptcha', 'https://www.google.com/recaptcha/api.js');
}
add_action('wp_enqueue_scripts', 'flowers_returns_enqueue_scripts');

function flowers_returns_form_shortcode() {
    ob_start(); ?>
    <form id="flowers-returns-form" method="post" enctype="multipart/form-data" onsubmit="return validateReturnForm();">
        <div class="form-grid">
            <div>
                <h3>Order Information</h3>
                <label class="required">First Name</label>
                <input type="text" name="first_name" required>
                <label class="required">Last Name</label>
                <input type="text" name="last_name" required>
                <label class="required">Order ID</label>
                <input type="text" name="order_id" required>
                <label class="required">Order Date</label>
                <input type="date" name="order_date" required>
                <label class="required">Email</label>
                <input type="email" name="email" required>
                <label class="required">Phone</label>
                <input type="text" name="phone" required>
            </div>
            <div>
                <h3>Product Info & Reason</h3>
                <label class="required">Product Name</label>
                <input type="text" name="product_name" required>
                <label class="required">Product Code</label>
                <input type="text" name="product_code" required>
                <label class="required">Quantity</label>
                <input type="number" name="quantity" value="1" required>

                <div class="radio-pair">
                    <div>
                        <label class="required">Product is opened</label>
                        <div class="radio-vertical">
                            <label><input type="radio" name="opened" value="Yes" required> Yes</label>
                            <label><input type="radio" name="opened" value="No" required checked> No</label>
                        </div>
                    </div>
                    <div>
                        <label class="required">Reason for Return</label>
                        <div class="radio-vertical">
                            <label><input type="radio" name="reason" value="Damaged" required> Damaged</label>
                            <label><input type="radio" name="reason" value="Received Wrong Item"> Received Wrong Item</label>
                            <label><input type="radio" name="reason" value="Defective"> Defective</label>
                            <label><input type="radio" name="reason" value="Others"> Others</label>
                        </div>
                    </div>
                </div>

                <label>Faulty or other details</label>
                <textarea name="details"></textarea>
                <label class="required">Upload Image</label>
                <input type="file" name="return_image" accept="image/*" required>

                <div class="g-recaptcha" data-sitekey="6LeEoVYrAAAAADmYOaMGJNaKWasB0P6uEH6kGJJY"></div>
                <div class="checkbox-group">
                    <label><input type="checkbox" name="agree" required> I agree to the <a href="/return-policy" target="_blank">Return Policy</a></label>
                </div>

                <input type="submit" name="submit_return" value="CONTINUE" class="submit-btn">
            </div>
        </div>
    </form>

    <div id="rma-popup" class="popup-overlay">
        <div class="popup-content">
            <p id="rma-message"></p>
            <button onclick="document.getElementById('rma-popup').style.display='none'">Close</button>
        </div>
    </div>

    <script>
    function validateReturnForm() {
        var response = grecaptcha.getResponse();
        if (response.length === 0) {
            alert("Please complete the reCAPTCHA.");
            return false;
        }
        return true;
    }
    </script>
    <?php
    if (isset($_POST['submit_return'])) {
        global $wpdb;
        $table_name = $wpdb->prefix . "flowers_returns";
        $rma = uniqid("RMA-");

        $image_url = "";
        if (!empty($_FILES['return_image']['name'])) {
            
    $file_type = wp_check_filetype($_FILES['return_image']['name']);
    $allowed_types = ['image/jpeg', 'image/png'];
    if (!in_array($file_type['type'], $allowed_types)) {
        echo "<script>alert('Only JPEG and PNG image formats are allowed.');</script>";
        return ob_get_clean();
    }
    $uploaded = wp_handle_upload($_FILES['return_image'], ['test_form' => false]);
    
            if (!isset($uploaded['error'])) {
                $image_url = esc_url_raw($uploaded['url']);
            }
        }

        $wpdb->insert($table_name, [
            'order_id' => sanitize_text_field($_POST['order_id']),
            'name' => sanitize_text_field($_POST['first_name'] . ' ' . $_POST['last_name']),
            'email' => sanitize_email($_POST['email']),
            'phone' => sanitize_text_field($_POST['phone']),
            'purchase_date' => sanitize_text_field($_POST['order_date']),
            'reason' => sanitize_text_field($_POST['reason']),
            'rma_number' => $rma,
            'status' => 'unapproved',
            'image_url' => $image_url,
        ]);

        wp_mail(get_option('admin_email'), "New Return Request", "A new return request has been submitted.\nRMA: $rma");
        wp_mail($_POST['email'], "Return Request Confirmation", "Thank you for your return request.\nYour RMA Number is: $rma");

        echo "<script>
        document.getElementById('rma-message').innerText = 'Thank you! Your RMA Number is: $rma';
        document.getElementById('rma-popup').style.display = 'flex';
        </script>";
    }
    return ob_get_clean();
}
add_shortcode('flowers_returns_form', 'flowers_returns_form_shortcode');

function flowers_returns_install() {
    global $wpdb;
    $table_name = $wpdb->prefix . "flowers_returns";
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        order_id varchar(100) NOT NULL,
        name varchar(100) NOT NULL,
        email varchar(100) NOT NULL,
        phone varchar(20) NOT NULL,
        purchase_date date NOT NULL,
        reason text NOT NULL,
        rma_number varchar(100) NOT NULL,
        status varchar(20) DEFAULT 'unapproved',
        image_url varchar(255),
        PRIMARY KEY (id)
    ) $charset_collate;";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'flowers_returns_install');

function flowers_returns_admin_menu() {
    add_menu_page('Return Requests', 'Return Requests', 'manage_options', 'flowers-returns', 'flowers_returns_admin_page');
}
add_action('admin_menu', 'flowers_returns_admin_menu');

function flowers_returns_admin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . "flowers_returns";

    if (isset($_GET['action']) && isset($_GET['id'])) {
        $status = ($_GET['action'] == 'approve') ? 'approved' : 'unapproved';
        $wpdb->update($table_name, ['status' => $status], ['id' => intval($_GET['id'])]);
    }

    $results = $wpdb->get_results("SELECT * FROM $table_name");
    echo "<h2>Return Requests</h2>";
    echo "<table class='wp-list-table widefat'>";
    echo "<tr><th>RMA</th><th>Name</th><th>Status</th><th>Action</th></tr>";
    foreach ($results as $row) {
        echo "<tr>";
        echo "<td>{$row->rma_number}</td><td>{$row->name}</td><td>{$row->status}</td>";
        echo "<td>
            <a href='?page=flowers-returns&action=approve&id={$row->id}' class='button'>Approve</a>
            <a href='?page=flowers-returns&action=unapprove&id={$row->id}' class='button'>Unapprove</a>
            <a href='?page=flowers-returns&view_id={$row->id}' class='button'>View Details</a>
        </td></tr>";
    }
    echo "</table>";

    if (isset($_GET['view_id'])) {
        $id = intval($_GET['view_id']);
        $data = $wpdb->get_row("SELECT * FROM $table_name WHERE id = $id");
        if ($data) {
            echo "<h3>Return Details</h3><ul>";
            foreach ($data as $key => $val) {
                if ($key === "image_url" && $val) {
                    echo "<li><strong>Uploaded Image:</strong><br><img src='$val' width='200'></li>";
                } else {
                    echo "<li><strong>" . ucfirst(str_replace('_', ' ', $key)) . ":</strong> $val</li>";
                }
            }
            echo "</ul>";
        }
    }
}
?>
