<?php
/**
 * Plugin Name: Custom Search Bar (Elementor Compatible)
 * Description: A styled search bar for Elementor with keyword validation and redirection.
 * Version: 1.3
 * Author: YourName
 */

function custom_search_bar_shortcode() { 
    ob_start(); ?>
    <form role="search" method="get" class="custom-search-form" onsubmit="return validateCustomSearch();" action="<?php echo esc_url(home_url('/')); ?>">
        <input type="search" id="custom-search-input" class="custom-search-input" name="s" placeholder="Quick search for anything..." />
        <button type="submit" class="custom-search-button">
            <span class="dashicons dashicons-search"></span>
        </button>
        <p id="custom-search-error" style="color: red; font-size: 12px; display: none; margin-top: 8px; padding-top: 5px;"></p>
    </form>

    <style>
        .custom-search-form {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: nowrap;
            width: 100%;
            max-width: 100%;
        }

        .custom-search-input {
            flex: 1;
            padding: 8px 10px;
            font-size: 14px;
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .custom-search-input::placeholder {
            color: #999;
            opacity: 0.8;
        }

        .custom-search-button {
            background-color: #ffffff00;
            color: #000;
            border: 1px solid #ccc;
            padding: 10px 14px;
            border-radius: 6px;
            cursor: pointer;
            box-shadow: 0 2px 6px rgba(0,0,0,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .custom-search-button:hover {
            background-color: #ffffff00;
            color: #fff;
        }

        @media (max-width: 480px) {
            .custom-search-form {
                width: 80%;
                margin: 0 auto;
            }

            .custom-search-input {
                padding: 7px 8px;
                font-size: 13px;
            }

            .custom-search-button {
                padding: 9px 12px;
            }
        }
    </style>

    <script>
        function validateCustomSearch() {
            var input = document.getElementById("custom-search-input");
            var error = document.getElementById("custom-search-error");
            if (input.value.trim() === "") {
                error.textContent = "Please enter a keyword";
                error.style.display = "block";
                return false;
            } else {
                error.style.display = "none";
                return true;
            }
        }
    </script>
<?php 
    return ob_get_clean();
}
add_shortcode('custom_search_bar', 'custom_search_bar_shortcode');
