self.addEventListener('install', () => {
  console.log("ABNC: Worker installed");
  self.skipWaiting();
});

self.addEventListener('activate', () => {
  console.log("ABNC: Worker activated");
  self.clients.claim();
});

// Duplicate of browser version for easy portability
function checkAbandonment() {
  console.log("ABNC: Checking for abandoned cart (worker)");
  fetch('/?abandoned_cart=1')
    .then(res => res.json())
    .then(data => {
      console.log("ABNC: Response", data);
      if (data.status === 'OK') {
        self.registration.showNotification(data.title, {
          body: data.message,
          icon: '/favicon.ico',
          data: { url: data.url }
        });
        console.log("ABNC: Notification shown");
      }
    })
    .catch(err => {
      console.error("ABNC: Error in check", err);
    });
}

setInterval(checkAbandonment, 10000);
checkAbandonment();

self.addEventListener('notificationclick', function (event) {
  console.log('ABNC: Notification clicked');
  event.notification.close();
  const url = event.notification.data?.url || 'https://yourdomain.com/checkout';
  event.waitUntil(
    clients.matchAll({ type: 'window' }).then(windowClients => {
      for (let client of windowClients) {
        if (client.url === url && 'focus' in client) {
          return client.focus();
        }
      }
      if (clients.openWindow) return clients.openWindow(url);
    })
  );
});
