if ('serviceWorker' in navigator && 'Notification' in window) {
  function initAbnc() {
    if (Notification.permission === 'granted') {
      navigator.serviceWorker.register('/wp-content/plugins/abandoned-cart-notify/worker.js?v=8')
        .then(() => console.log("ABNC: Worker registered"))
        .catch(console.error);
    } else {
      console.log("ABNC: Notification permission not granted");
    }
  }

  window.requestAbncPermission = function () {
    Notification.requestPermission().then(permission => {
      if (permission === 'granted') {
        navigator.serviceWorker.register('/wp-content/plugins/abandoned-cart-notify/worker.js?v=8')
          .then(() => console.log("ABNC: Worker registered after user permission"))
          .catch(console.error);
      } else {
        console.warn("ABNC: Notifications blocked by user");
      }
    });
  };

  initAbnc();
}
