(function () {
  if (!('Notification' in window)) {
    //console.log("ABNC: Notifications not supported.");
    return;
  }

  // Start polling if permission was already granted
  function initAbnc() {
    if (Notification.permission === 'granted') {
      //console.log("ABNC: Permission already granted, starting polling");
      startPolling();
    } else {
      //console.log("ABNC: Permission not granted, waiting for user action");
    }
  }

  // Must be triggered by user action
  window.requestAbncPermission = function () {
    Notification.requestPermission().then(permission => {
     // console.log("ABNC: User triggered permission:", permission);
      if (permission === 'granted') {
        startPolling();
      }
    });
  };

  function startPolling() {
   // console.log("ABNC: Starting polling loop");
    setInterval(checkAbandonment, 10000);
    checkAbandonment();
  }

  function checkAbandonment() {
  //  console.log("ABNC: Checking for abandoned cart");
    fetch('/?abandoned_cart=1')
      .then(res => res.json())
      .then(data => {
        console.log("ABNC: Response", data);
        if (data.status === 'OK') {
          const notification = new Notification(data.title, {
            body: data.message,
            icon: '/favicon.ico'
          });
          notification.onclick = function () {
            window.open(data.url);
          };
        }
      }).catch(err => {
        console.error("ABNC: Error in check", err);
      });
  }

  // Only initialize, not request
  initAbnc();
})();
