<?php
// Schedule a WP Cron event
add_action('woocommerce_cart_updated', function () {
    if (!is_user_logged_in()) return;

    $user_id = get_current_user_id();
    update_user_meta($user_id, '_wacp_cart_timestamp', time());

    if (!wp_next_scheduled('wacp_check_cart_abandonment', [$user_id])) {
        wp_schedule_single_event(time() + 60, 'wacp_check_cart_abandonment', [$user_id]);
    }
});

// Cron job handler with cart check
add_action('wacp_check_cart_abandonment', function ($user_id) {
    $last = get_user_meta($user_id, '_wacp_cart_timestamp', true);
    if ($last && (time() - $last) >= 60) {
        delete_user_meta($user_id, '_wacp_cart_timestamp');

        wp_set_current_user($user_id);
        WC()->session = new WC_Session_Handler();
        WC()->session->init();
        WC()->cart = new WC_Cart();
        WC()->cart->get_cart_from_session();

        if (WC()->cart && WC()->cart->get_cart_contents_count() > 0) {
            $code = wacp_create_discount_coupon($user_id);
            update_user_meta($user_id, '_wacp_coupon_code', $code);
            error_log("WACP: Coupon created and saved for user {$user_id}");
        } else {
            error_log("WACP: Cart empty — no coupon created for user {$user_id}");
        }
    }
});

// Set cookie on next page load
add_action('init', function () {
    if (!is_user_logged_in()) return;

    $user_id = get_current_user_id();
    $coupon_code = get_user_meta($user_id, '_wacp_coupon_code', true);

    if ($coupon_code && empty($_COOKIE['wacp_discount'])) {
        setcookie('wacp_discount', $coupon_code, time() + 3600, "/");
        error_log("WACP: Cookie set for user {$user_id}");
    }
});