<?php
function wacp_create_discount_coupon($user_id) {
    $code = 'WAC10_' . wp_generate_password(6, false);
    $coupon = new WC_Coupon();
    $coupon->set_code($code);
    $coupon->set_discount_type('percent');
    $coupon->set_amount(10);
    $coupon->set_usage_limit(1);
    $coupon->set_date_expires(strtotime('+2 days'));
    $coupon->set_description('Auto-generated abandoned cart discount');
    $coupon->save();

    if (defined('WP_DEBUG') && WP_DEBUG === true) {
        error_log("WACP: Created coupon {$code} for user ID {$user_id}");
    }

    return $code;
}
?>
