document.addEventListener("DOMContentLoaded", function () {
  console.log("🔄 push.js loaded");

  // Register Service Worker
  if ('serviceWorker' in navigator) {
    navigator.serviceWorker.register('/wp-content/plugins/woo-abandoned-cart-push/assets/push-sw.js')
      .then(() => console.log("✅ Service Worker registered"))
      .catch(err => console.warn("❌ Service Worker error", err));
  }

  // Auto-remove discount cookie if cart is now empty
  const cartEmpty = !localStorage.getItem('wc_cart_created') &&
                    !document.cookie.includes('woocommerce_items_in_cart=1');
  if (cartEmpty && document.cookie.includes('wacp_discount=')) {
    document.cookie = "wacp_discount=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;";
    console.log("🧹 wacp_discount cookie removed — cart is empty");
    return; // stop further processing
  }

  // Check for coupon cookie
  if ('Notification' in window) {
    console.log("🔔 Notifications supported");

    const match = document.cookie.match(/wacp_discount=([^;]+)/);
    const coupon = match ? match[1] : null;

    if (coupon) {
      console.log("✅ Coupon found in cookie:", coupon);

      try {
        const n = new Notification("🛒 You left items in your cart!", {
          body: "Come back and get 10% off! Code: " + coupon,
          icon: "https://cdn-icons-png.flaticon.com/512/263/263115.png"
        });
        console.log("🚀 Notification triggered");

        setTimeout(() => {
          if (!n || typeof n.close !== "function") {
            console.warn("⚠️ Notification not rendered, showing alert fallback");
            alert("🛒 You left items in your cart! Use code: " + coupon + " to get 10% off.");
          } else {
            console.log("✅ Notification object created successfully");
            alert("🛒 (Also showing fallback) Use code: " + coupon + " to get 10% off.");
          }
        }, 500);

      } catch (err) {
        console.error("❌ Notification failed:", err);
        alert("🛒 You left items in your cart! Use code: " + coupon + " to get 10% off.");
      }

    } else {
      console.log("❌ No coupon cookie found");
    }
  } else {
    console.log("❌ Notifications not supported in this browser");
  }
});